from api import *


"""
Comparé aux précédentes versions de mon code, celui-ci ne fonctionne pas grâce à Dieu et est facilement explicable:
Les troupes de canard se dirigent toujours soit vers un nid pour se vider, soit vers un pain.
Le mouvement des troupes ne tient pas compte des mouvements de l'adversaire, la technique est d'être
plus rapide que l'adversaire sur les pains et sur les nids, sans occuper trop d'espace sur la carte.
Bugs potentiels:
    - Si la case ciblée est occupée par un de ses canards, elle risque de prendre un mur en face
    - Reste bloquée s'il faut utiliser les tunnels (technicité trop importante à coder + time-out)
    - Ne fonctionne plus correctement si les constantes PTS_ACTION et COUT_CROISSANCE ne sont
      plus respectivement définies sur 5 et 3
Bugs supposés corrigés:
    - L'IA ne se suicide plus d'elle-même sur un de ses canards
    - L'inventaire reste à jour
    - L'IA ne grandi pas de trop (jugé sur les données des exemples)
Pistes d'amélioration de la technicité:
    - Déclarer deux fonctions pour les deux blocs différent dans jouer_tour (pain et nid)
      afin d'éviter la répétition et la lourdeur du code ; favoriser la clarté
    - Eviter les changements de type des variables (bool --> list)
Pistes d'amélioration de l'IA:
    - Apprendre l'utilisation des tunnels et les creuser
    - En fonction de l'inventaire de l'adversaire, bloquer sa route vers le pain le plus
      plus proche par un buisson 
    - Rendre le programme indépendant des constantes PTS_ACTION et COUT_CROISSANCE
    - Optimiser les déplacements vers les pains en fonction des futurs pains, connus
      par la constante INTERVALLE_DISTRIB
"""


# Fonction qui vérifie qu'un mouvement soit possible
def verif_deplacement(dir, k):
    """
    Vérifie qu'un mouvement demandé ne rencontre pas un canard de la troupe
    :param dir: la direction initialement prévue ; tuple()
    :param k: le numéro de la troupe dont on s'occupe ; int
    :return: le déplacement à faire en fonction des données récupérées ; tuple()
    """
    pos = troupes_joueur(moi())[k].maman

    # Donne les coordonnées de la case ciblée par le prochain déplacement
    if dir == direction.EST:
        deplacement = (pos[0] + 1, pos[1], pos[2])
    elif dir == direction.OUEST:
        deplacement = (pos[0] - 1, pos[1], pos[2])
    elif dir == direction.NORD:
        deplacement = (pos[0], pos[1] + 1, pos[2])
    elif dir == direction.SUD:
        deplacement = (pos[0], pos[1] - 1, pos[2])
    elif dir == direction.HAUT:
        deplacement = (pos[0], pos[1], pos[2] + 1)
    else:
        deplacement = (pos[0], pos[1], pos[2] - 1)

    # Vérifie que la case est traversable, continue dans la même direction sinon
    if deplacement in troupes_joueur(moi())[k].canards:
        return troupes_joueur(moi())[k].dir
    else:
        return dir



# Fonction appelée au début de la partie.
def partie_init():
    # TODO
    global nids  # tunnel_1, tunnel_2

    # Enregistre tous les nids et les tunnels
    nids = []
    # trous = []
    for i in range(HAUTEUR):
        for j in range(LARGEUR):
            if info_case((i, j, 0)).contenu == type_case.NID:
                nids.append((i, j, 0))
            # elif info_case((i, j, 0)).contenu == type_case.TROU:
            #     trous.append((i, j, 0))

    # # Construit le tunnel le plus proche de chaque troupe
    # chemin_1, chemin_2 = False, False
    # for i in trous:  # Trouve le tunnel le plus proche de chaque troupe
    #     temp_1 = trouver_chemin(troupes_joueur(moi())[0].maman, i)
    #     temp_2 = trouver_chemin(troupes_joueur(moi())[1].maman, i)
    #     if chemin_1 is False and len(temp_1) > 0:
    #         chemin_1 = temp_1
    #         trou_1 = i
    #     elif 0 < len(temp_1) < len(chemin_1):
    #         chemin_1 = temp_1
    #         trou_1 = i
    #     if chemin_2 is False and len(temp_2) > 0:
    #         chemin_2 = temp_2
    #         trou_2 = i
    #     elif 0 < len(temp_2) < len(chemin_2):
    #         chemin_2 = temp_2
    #         trou_2 = i
    # tunnel_1 = False
    # tunnel_2 = False  # Cherche le chemin entre les 2 tunnels du dessus et leur tunnel le plus proche
    # for i in trous:
    #     temp_1 = trouver_chemin(trou_1, i)
    #     temp_2 = trouver_chemin(trou_2, i)
    #     if tunnel_1 is False and len(temp_1) > 0:
    #         tunnel_1 = temp_1
    #     elif 0 < len(temp_1) < len(tunnel_1):
    #         tunnel_1 = temp_1
    #     if tunnel_2 is False and len(temp_2) > 0:
    #         tunnel_2 = temp_2
    #     elif 0 < len(temp_2) < len(tunnel_2):
    #         tunnel_2 = temp_2
    # Faire une fonction pour tracer le chemin à croiser /\ Trop long, risque de time-out /\


# Fonction appelée à chaque tour.
def jouer_tour():
    # TODO

    # # Détermine les nids libres
    # libre = []
    # for i in nids:
    #     if info_nid(i) == etat_nid.LIBRE:
    #         libre.append(i)

    # Parcours de la troupe 1 puis de la troupe 2, et grossissement arbitraire des troupes
    k = -1
    for i in troupes_joueur(moi()):
        k += 1
        if tour_actuel() > 10 and tour_actuel() % 2 == 0 and troupes_joueur(moi())[k].taille < 12:
            grandir(troupes_joueur(moi())[k].id)

        # # Rush les nids libres
        # if len(libre) > 0:
        #     chemin = False
        #     for j in libre:
        #         # Cherche le nid accessible le plus proche
        #         if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
        #             chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
        #         else:
        #             chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
        #             if 0 < len(chemin_temp) < len(chemin):
        #                 chemin = chemin_temp
        #     # Avance vers ce nid tant que possible (chemin existant ou pts_actions restants)
        #     while type(chemin) == list and len(chemin) >= 1:
        #         avancer(troupes_joueur(moi())[k].id, chemin[0])
        #         chemin = chemin[1:]

        pain = []
        for m in pains():
            if m not in pain:
                pain.append(m)
        # Va cherche du pain si l'inventaire n'est pas plain et que des miches sont disponibles
        if troupes_joueur(moi())[k].inventaire < inventaire(troupes_joueur(moi())[k].taille) and pain != []:
            chemin = False
            for j in pain:
                # Cherche le chemin vers le pain le plus proche
                if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
                    chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                else:
                    chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                    if 0 < len(chemin_temp) < len(chemin):
                        chemin = chemin_temp
            # Avance vers le pain tant que possible (chemin existant ou pts_action restants)
            while type(chemin) == list and len(chemin) >= 1 and troupes_joueur(moi())[k].pts_action > 0:
                avancer(troupes_joueur(moi())[k].id, verif_deplacement(chemin[0], k))
                chemin = chemin[1:]
            # S'il reste des points d'action, se dirige vers un nid ou grandi
            if troupes_joueur(moi())[k].pts_action >= 3:
                grandir(troupes_joueur(moi())[k].id)
            if 3 > troupes_joueur(moi())[k].pts_action > 0:
                if nids != []:
                    nid = []
                    for j in nids:
                        # Cherche tous les nids libres ou au joueur
                        nid_info = str(info_nid(j))
                        if str(moi()) in nid_info or info_nid(j) == etat_nid.LIBRE:
                            nid.append(j)
                    if nid != []:
                        chemin = False
                        for j in nid:
                            # Cherche le nid accessible le plus proche
                            if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
                                chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                            else:
                                chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                if 0 < len(chemin_temp) < len(chemin):
                                    chemin = chemin_temp
                        # Avance vers ce nid tant que possible (chemin existant ou pts_actions restants)
                        while type(chemin) == list and len(chemin) >= 1:
                            avancer(troupes_joueur(moi())[k].id, verif_deplacement(chemin[0], k))
                            chemin = chemin[1:]
                        # S'il reste des points d'action, se dirige vers du pain si inventaire non plein
                        if 3 > troupes_joueur(moi())[k].pts_action > 0:
                            pain = []
                            for m in pains():
                                if m not in pain:
                                    pain.append(m)
                            if troupes_joueur(moi())[k].inventaire < inventaire(troupes_joueur(moi())[k].taille) and pain != []:
                                chemin = False
                                for j in pain:
                                    # Cherche le chemin vers le pain le plus proche
                                    if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
                                        chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                    else:
                                        chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                        if 0 < len(chemin_temp) < len(chemin):
                                            chemin = chemin_temp
                            # Avance vers le pain tant que possible (chemin existant ou pts_action restants)
                            while type(chemin) == list and len(chemin) >= 1:
                                    avancer(troupes_joueur(moi())[k].id, verif_deplacement(chemin[0], k))
                                    chemin = chemin[1:]

        else:
            # Va vers un nid puisque aucun pain n'est disponible
            if nids != []:
                nid = []
                for j in nids:
                    # Cherche tous les nids libres ou au joueur
                    nid_info = str(info_nid(j))
                    if str(moi()) in nid_info or info_nid(j) == etat_nid.LIBRE:
                        nid.append(j)
                if nid != []:
                    chemin = False
                    for j in nid:
                        # Cherche le nid accessible le plus proche
                        if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
                            chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                        else:
                            chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                            if 0 < len(chemin_temp) < len(chemin):
                                chemin = chemin_temp
                    # Avance vers ce nid tant que possible (chemin existant ou pts_actions restants)
                    while type(chemin) == list and len(chemin) >= 1 and troupes_joueur(moi())[k].pts_action > 0:
                        avancer(troupes_joueur(moi())[k].id, verif_deplacement(chemin[0], k))
                        chemin = chemin[1:]
                    # S'il reste des points d'action, se dirige vers du pain ou grandi
                    if troupes_joueur(moi())[k].pts_action >= 3:
                        grandir(troupes_joueur(moi())[k].id)
                    if 3 > troupes_joueur(moi())[k].pts_action > 0:
                        pain = []
                        for m in pains():
                            if m not in pain:
                                pain.append(m)
                        # Va cherche du pain si l'inventaire n'est pas plain et que des miches sont disponibles
                        if troupes_joueur(moi())[k].inventaire < inventaire(troupes_joueur(moi())[k].taille) and pain != []:
                            chemin = False
                            for j in pain:
                                # Cherche le chemin vers le pain le plus proche
                                if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
                                    chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                else:
                                    chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                    if 0 < len(chemin_temp) < len(chemin):
                                        chemin = chemin_temp
                        # Avance vers le pain tant que possible (chemin existant ou pts_action restants)
                        while type(chemin) == list and len(chemin) >= 1:
                            avancer(troupes_joueur(moi())[k].id, verif_deplacement(chemin[0], k))
                            chemin = chemin[1:]
                        # S'il reste des points d'action, se dirige vers un nid
                        if 3 > troupes_joueur(moi())[k].pts_action > 0:
                            if nids != []:
                                nid = []
                                for j in nids:
                                    # Cherche tous les nids libres ou au joueur
                                    nid_info = str(info_nid(j))
                                    if str(moi()) in nid_info or info_nid(j) == etat_nid.LIBRE:
                                        nid.append(j)
                                if nid != []:
                                    chemin = False
                                    for j in nid:
                                        # Cherche le nid accessible le plus proche
                                        if chemin is False and len(trouver_chemin(troupes_joueur(moi())[k].maman, j)) > 0:
                                            chemin = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                        else:
                                            chemin_temp = trouver_chemin(troupes_joueur(moi())[k].maman, j)
                                            if 0 < len(chemin_temp) < len(chemin):
                                                chemin = chemin_temp
                                    # Avance vers ce nid tant que possible (chemin existant ou pts_actions restants)
                                    while type(chemin) == list and len(chemin) >= 1:
                                        avancer(troupes_joueur(moi())[k].id, verif_deplacement(chemin[0], k))
                                        chemin = chemin[1:]


# Fonction appelée à la fin de la partie.
def partie_fin():
    # TODO
    pass
